---
name: Bug Report
about: Report a bug or an unexpected behavior with the API 
labels: bug
---
# Bug Report

---

### Notes:
We will close your issue, sometimes without answering, if any of the following are met:
* You have not included your code or your debug log
* You are asking about `challenge_required`, `checkpoint_required`, `feedback_required` or `sentry_block`. They've already been answered in the Wiki and *countless* closed tickets in the past!
* You have used the wrong issue template
* You are posting screenshots, which are too painful to help you with 

Please make sure you have done the following before submitting your issue:
* You have [Searched](https://github.com/mgp25/Instagram-API/search?type=Issues) the bug-tracker for similar issues including **closed** ones
* You have [Read the FAQ](https://github.com/mgp25/Instagram-API/wiki/FAQ)
* You have [Read the wiki](https://github.com/mgp25/Instagram-API/wiki)
* You have [Reviewed the examples](https://github.com/mgp25/Instagram-API/tree/master/examples)
* You have [Installed the api using ``composer``](https://github.com/mgp25/Instagram-API#installation)
* You are [Using latest API release](https://github.com/mgp25/Instagram-API/releases)

---

### Description
Please include a well-worded description of your issue below; We will close your issue if we have to guess what you're talking about, please be as specific as possible:

__INSERT YOUR DESCRIPTION HERE__

### Code
Please post your code relevant to the bug in the section below:
```php
INSERT YOUR CODE HERE
``` 

### Debug Log
Please post your debug log in the section below; You can enable the debug log by using `new Instagram(true)` instead of `new Instagram()`:
```php
INSERT YOUR DEBUG LOG HERE
```