--
-- Database: `sima_db`
--
DROP DATABASE IF EXISTS `sima_db`;
CREATE DATABASE IF NOT EXISTS `sima_db` DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci;
USE `sima_db`;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_admin`
--

DROP TABLE IF EXISTS `tbl_admin`;
CREATE TABLE IF NOT EXISTS `tbl_admin` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `Name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `LastName` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `UserName` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Pass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `tbl_admin`
--

INSERT INTO `tbl_admin` (`id`, `Name`, `LastName`, `UserName`, `Pass`, `Type`) VALUES
(1, 'ادمین', 'ادمین', 'Admin', '123456', 'Main');

-- --------------------------------------------------------

--
-- Table structure for table `tbl_announce`
--

DROP TABLE IF EXISTS `tbl_announce`;
CREATE TABLE IF NOT EXISTS `tbl_announce` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `img_url1` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `img_url2` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `num` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `title` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `author` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `tbl_announce`
--

INSERT INTO `tbl_announce` (`id`, `img_url1`, `img_url2`, `date`, `description`, `num`, `title`, `author`) VALUES
(7, 'uploadImage/Announce/img1_announce_2.jpg', 'uploadImage/Announce/img2_announce_2.jpg', '1398/9/23', 'اطلاعیه جدید ۱', '2', 'اطلاعیه جدید', 'ادمین ادمین'),
(5, NULL, NULL, '1398/4/22', '۱', NULL, '۱', 'ادمین ادمین'),
(6, NULL, NULL, '1398/9/23', 'رازدا', NULL, 'تست جدید', 'ادمین ادمین');

-- --------------------------------------------------------

--
-- Table structure for table `tbl_api`
--

DROP TABLE IF EXISTS `tbl_api`;
CREATE TABLE IF NOT EXISTS `tbl_api` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `google_api` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `tbl_api`
--

INSERT INTO `tbl_api` (`id`, `google_api`) VALUES
(1, 'pk.eyJ1IjoibmFyZXphMjEiLCJhIjoiY2pzcTR3ZjNyMTRnNTQzcDE5YXFnMW5heCJ9.yE4seVKjxiGtTzKnOM906w');

-- --------------------------------------------------------

--
-- Table structure for table `tbl_darmani`
--

DROP TABLE IF EXISTS `tbl_darmani`;
CREATE TABLE IF NOT EXISTS `tbl_darmani` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `id_ref` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `img_url` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `feuture` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lat_map` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lng_map` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `tbl_darmani`
--

INSERT INTO `tbl_darmani` (`id`, `id_ref`, `name`, `img_url`, `feuture`, `address`, `phone`, `lat_map`, `lng_map`) VALUES
(1, '', 'تست ۱', NULL, 'عالی -خوب -زیبا', 'اردبیل', '04533333333-04533222222', '38.2538', '48.2945'),
(2, '', 'تست ۱', NULL, 'عالی -خوب -زیبا', 'اردبیل', '04533333333-04533222222', '38.2538', '48.2945'),
(3, '', 'بیمارستان سبلان', NULL, 'عالی -زیبا', 'میدان وحدت', '04533333333-04522332233', '38.2263', '48.2884'),
(4, '9', 'بیمارستان سبلان', NULL, 'عالی -زیبا', 'میدان وحدت', '04533333333-04522332233', '38.2263', '48.2884'),
(5, '10', 'بیمارستان آرتا', NULL, 'فوق تخصص - محیط زیبا', 'اردبیل خیابان سی متری', '04533512356-04533223322', '38.2488', '48.2997');

-- --------------------------------------------------------

--
-- Table structure for table `tbl_darmani_cat`
--

DROP TABLE IF EXISTS `tbl_darmani_cat`;
CREATE TABLE IF NOT EXISTS `tbl_darmani_cat` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `img_url` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `num` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `tbl_darmani_cat`
--

INSERT INTO `tbl_darmani_cat` (`id`, `name`, `img_url`, `num`) VALUES
(12, 'فیزیوتراپی', 'uploadImage/khadamate_Darmani/img1_darmani_4.jpg', '4'),
(11, 'آرمایشگاه', 'uploadImage/khadamate_Darmani/img1_darmani_3.jpg', '3'),
(10, 'بیمارستان خصوصی', 'uploadImage/khadamate_Darmani/img1_darmani_2.jpg', '2'),
(9, 'بیمارستان دولتی', 'uploadImage/khadamate_Darmani/img1_darmani_1.jpg', '1'),
(13, 'رادیولوژی', 'uploadImage/khadamate_Darmani/img1_darmani_5.jpg', '5'),
(14, 'داروخانه', 'uploadImage/khadamate_Darmani/img1_darmani_6.jpg', '6'),
(15, 'پرشکان', 'uploadImage/khadamate_Darmani/img1_darmani_7.jpg', '7'),
(16, 'کلینیک', 'uploadImage/khadamate_Darmani/img1_darmani_8.jpg', '8'),
(17, 'درمانگاه', 'uploadImage/khadamate_Darmani/img1_darmani_9.jpg', '9');

-- --------------------------------------------------------

--
-- Table structure for table `tbl_lock`
--

DROP TABLE IF EXISTS `tbl_lock`;
CREATE TABLE IF NOT EXISTS `tbl_lock` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `lock_app` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `tbl_lock`
--

INSERT INTO `tbl_lock` (`Id`, `lock_app`) VALUES
(1, 'UNLOCK');

-- --------------------------------------------------------

--
-- Table structure for table `tbl_mehmansara`
--

DROP TABLE IF EXISTS `tbl_mehmansara`;
CREATE TABLE IF NOT EXISTS `tbl_mehmansara` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `LatMap` int(20) DEFAULT NULL,
  `LngMap` int(20) DEFAULT NULL,
  `img_url` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `num` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_message`
--

DROP TABLE IF EXISTS `tbl_message`;
CREATE TABLE IF NOT EXISTS `tbl_message` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `Title` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Message` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Date` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Author` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `tbl_message`
--

INSERT INTO `tbl_message` (`id`, `Title`, `Message`, `Date`, `Author`) VALUES
(1, 'تست', 'تست\n\n۲', '1398/4/20', 'ادمین ادمین'),
(2, 'تست', 'تست۱', '1398/4/20', 'ادمین ادمین'),
(3, 'تست', '۱۲۳۴۵۶۷۸۹۰۰۰', '1398/4/20', 'ادمین ادمین'),
(4, '۲۲۳', '۲۲۳', '1398/4/22', 'ادمین ادمین'),
(5, 'پیام جدید', 'تست پیام', '1398/9/23', 'ادمین ادمین');

-- --------------------------------------------------------

--
-- Table structure for table `tbl_refahi`
--

DROP TABLE IF EXISTS `tbl_refahi`;
CREATE TABLE IF NOT EXISTS `tbl_refahi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_ref` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `feuture` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `img_url` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lat_map` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lng_map` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_refahi_cat`
--

DROP TABLE IF EXISTS `tbl_refahi_cat`;
CREATE TABLE IF NOT EXISTS `tbl_refahi_cat` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `img_url` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `num` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `tbl_refahi_cat`
--

INSERT INTO `tbl_refahi_cat` (`id`, `name`, `img_url`, `num`) VALUES
(5, 'دسته بندی جدید', 'uploadImage/khadamate_Refahi/img1_refahi_1.jpg', '1');

-- --------------------------------------------------------

--
-- Table structure for table `tbl_update`
--

DROP TABLE IF EXISTS `tbl_update`;
CREATE TABLE IF NOT EXISTS `tbl_update` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `url` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `version` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `tbl_update`
--

INSERT INTO `tbl_update` (`id`, `url`, `version`) VALUES
(1, NULL, '1'),
(2, NULL, '1');

-- --------------------------------------------------------

--
-- Table structure for table `tbl_user`
--

DROP TABLE IF EXISTS `tbl_user`;
CREATE TABLE IF NOT EXISTS `tbl_user` (
  `Id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `Name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Surname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `NationalCode` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Mobile` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `tbl_user`
--

INSERT INTO `tbl_user` (`Id`, `Name`, `Surname`, `NationalCode`, `Mobile`) VALUES
(1, 'رضا', 'نظری', '1450262376', '09148214511'),
(2, 'فرشاد', 'فرزانه وش', '0492751651', '09143541672'),
(3, 'فرشید', 'الهیارخانی', '1467131342', '09147075560'),
(4, 'شمس الدین', 'محمدی', '1465857631', '09147038638');
